/*******************************************************
Filename		:  	DW_exec_os.java
Release 		:  	STORET c2.0.1
SIR			:  	1557
Description		:  	Used to call GZIP to create compressed report files.
Author			:  	Ganesh Thadkamall; Christine Tsang; Joseph Wilson
Date			: 	October 8, 2003
Comments		:  	
**********************************************************/

CREATE OR REPLACE JAVA SOURCE NAMED "ExecOS" AS

import java.util.*;
import java.io.*;


class CaptureStream implements Runnable {

    private final InputStream is;
    private final String type;
    private final OutputStream redirect;
    private boolean  redirected = false;

    CaptureStream(InputStream is, String type, OutputStream redirect)
    {
        this.is = is;
        this.type = type + ">";
        this.redirect = redirect;
    }

    CaptureStream(InputStream is, String type)
    {
        this(is, type, null);
    }

    CaptureStream(InputStream is)
    {
        this(is, " ", null);
    }

    public void run()
    {
        try {
            PrintWriter pw = null;
            if (redirect != null) {
                pw = new PrintWriter(redirect);
                redirected = true;
            }

            InputStreamReader isr = new InputStreamReader(is);
            BufferedReader br = new BufferedReader(isr);
            String line=null;
            while ( (line = br.readLine()) != null) {
                System.out.println(type + line);    
                if (redirected) {
                    pw.println(line);
                }
            }
            if (redirected) {
                pw.flush();
                pw.close();
            }

            br.close();
            isr.close();

        } catch (IOException ioe) {
            ioe.printStackTrace();  
        }
    }
}

public class ExecOS {
    public static int execos(String unix_cmd) 
    {
        int rc = 0;

        try {
            String cmd = unix_cmd;
            FileOutputStream fos = null;
	    /*
            if (args.length == 2 ) {
                fos = new FileOutputStream(args[1]);
            }
	    */
		fos = null;
            Runtime rt = Runtime.getRuntime();
            Process p = rt.exec(cmd);


            CaptureStream err = new CaptureStream(p.getErrorStream(), "ERR");            
            Thread e = new Thread(err);

            /* NOTE we do not join the error thread.  If there was no
	       Error it may never return.  We would wait forever for it to 
	       return thus janging this process */ 
            e.start();

            CaptureStream out = new CaptureStream(p.getInputStream(), 
                                                  "OUT", fos);
            Thread o = new Thread(out);
            o.start();

            try {
                rc = p.waitFor();

                /* Handle exceptions for waitFor() */ 
            } catch (InterruptedException intexc) {
                System.out.println("Interrupted Exception on waitFor: " + 
                                   intexc.getMessage()); 
            }

            if (fos !=null) {
                o.join();      // need to wait for the output to finish.
                fos.flush();
                fos.close();
            }

            System.out.println("ExitValue: " + rc);
            return rc;
           
        } catch (Throwable t) {
            System.out.println("ExitValue: " + rc);
            t.printStackTrace();
            return rc;
        }
    }
}
/
ALTER java source "ExecOS" compile;
show errors java source "ExecOS"
/
CREATE OR REPLACE FUNCTION execmd(cmd in VARCHAR2) return number 
as LANGUAGE JAVA 
name 'ExecOS.execos(java.lang.String) return int'; 
/
show errors;


